/**
 * Wrapper for server
 * - acts as interface for communication with server
 * - other classes uses it's methods to do requests
 */
var Server = new Class({
  Implements: [Options],
  options: {
//    url: "http://home/clim_server/index.php",
    url: "http://clim.php5.sk/server/index.php",
    method: air.URLRequestMethod.POST,
    silent: false // whether to show modal overlay or not - defaults to false (show overlay)
  },
  last_request: null,
  overlay: new Modalizer(),  
  
  initialize: function(options){
    this.setOptions(options);
  },
  
  // shows window overlay and loader icon
  showLoader: function(){
    if(this.options.silent) return;
    this.overlay.modalShow({
      hideOnClick: false,
      modalStyle: {
        position: 'fixed'
      },
      onModalShow: function(){},
      onModalHide: function(){},
    });
  },
  
  hideLoader: function(){
    if(this.options.silent) return;
    this.overlay.modalHide();
  },
  
  request: function(data, onComplete){  
    var t = this;
    function completeHandler(event) {
      var response = null;
      try {
        response = JSON.decode(event.target.data);
      } catch(e){
        trace("Wrong response:");
        trace(event.target.data);
      }
      
      if($defined(response) && $defined(response.error)){
        response.error.message = decodeURIComponent(response.error.message);
        trace("Response error #"+response.error.code+": "+response.error.message);
        alert(response.error.message);
      }  
      
      t.hideLoader();
      if($defined(onComplete)) onComplete(response);
    }
		
    this.showLoader()
    var req = new air.URLRequest(); 
    req.useCache = false;
    req.cacheResponse = false;
    req.url = this.options.url; 
    req.method = this.options.method; 
    
    var d = encodeURIComponent(JSON.encode(data));
    req.data = new air.URLVariables("request="+d); 
    
    var loader = new air.URLLoader(); 
    loader.dataFormat = air.URLLoaderDataFormat.TEXT; 
    loader.addEventListener(air.Event.COMPLETE, completeHandler); 
    try { 
      loader.load(req); 
    } catch (error) { 
      air.trace("Unable to load URL"); 
      this.hideLoader();
    }      
  }
});